function [F] = equation(X)

% EQUATION Calculates the value of the system of equations for Schmitt 
%          Trigger Circuit 1 (Modified Nodal Equations)

% Circuit Parameters

r1 = 100;
r2 = 50;

% BJT Parameters

q1IS = 1e-14;
q1BF = 200;
q1BR = 3;
q1N = 38.78;
q2IS = 1e-14;
q2BF = 250;
q2BR = 3;
q2N = 38.78;

% Ebers-Moll Transistor Model

% fe1 = -q1IS/q1BF*(exp(-q1N*(-X(3))) -1);
% fc1 = -q1IS/q1BR*(exp(-q1N*(X(2)-X(3))) -1);
% fe2 = -q2IS/q2BF*(exp(q2N*(X(3)-X(2))) -1);
% fc2 = -q2IS/q2BR*(exp(q2N*(X(1)-X(2))) -1);
% 
% Ie1 = fe1 - q1BR*fc1;
% Ic1 = fc1 - q1BF*fe1;
% Ie2 = fe2 - q2BR*fc2;
% Ic2 = fc2 - q2BF*fe2;

% System of Equations for Schmitt Trigger Circuit 1 (Modified Nodal Equations)

% F(1) = (X(2)-X(1))/r1 + (X(2))/r2 + Ic1 + Ic2 - Ie2; 
% 
% F(2) = -Ic2 -Ic1 + Ie1;
% 
% F(3) = -2e-03 + (X(1)-X(2))/r1 + Ie2;
F(1) =  (q1IS )*(exp(-q1N*(-X(3))) -1) + (-q1IS /q1BR )*(1+q1BR )*(exp(-q1N*(X(2)-X(3))) -1) + (q2IS )*(exp(q2N*(X(1)-X(2))) -1) + (-q2IS /q2BR )*(1+q2BR )*(exp(q2N*(X(3)-X(2))) -1) + (-q2IS /q2BF )*(1+q2BF )*(exp(q2N*(X(1)-X(2))) -1) - (-q2IS )*(exp(q2N*(X(3)-X(2))) -1) + (X(2)-X(1))/r1 + (X(2))/r2 ;

F(2) =  (-q1IS )*(exp(-q1N*(-X(3))) -1) + (q1IS /q1BR )*(1+q1BR )*(exp(-q1N*(X(2)-X(3))) -1) + (q1IS /q1BF )*(1+q1BF )*(exp(-q1N*(-X(3))) -1) - ( q1IS )*(exp(-q1N*(X(2)-X(3))) -1) + (-q2IS )*(exp(q2N*(X(1)-X(2))) -1) + (q2IS /q2BR )*(1+q2BR )*(exp(q2N*(X(3)-X(2))) -1) ;

F(3) =  (q2IS /q2BF )*(1+q2BF )*(exp(q2N*(X(1)-X(2))) -1) - ( q2IS )*(exp(q2N*(X(3)-X(2))) -1) + (X(1)-X(2))/r1 - (2e-08) ;

F = F';

end